<?php

class Pi_Mmq_Menu{

    public $plugin_name;
    public $menu;
    
    function __construct($plugin_name , $version){
        $this->plugin_name = $plugin_name;
        $this->version = $version;
        add_action( 'admin_menu', array($this,'plugin_menu') );
        add_action($this->plugin_name.'_promotion', array($this,'promotion'));
    }

    function plugin_menu(){
        
        $this->menu = add_menu_page(
            __( 'Min/Max Quantity'),
            __( 'Min/Max Quantity'),
            'manage_options',
            'pisol-mmq-notification',
            array($this, 'menu_option_page'),
            plugin_dir_url( __FILE__ ).'img/pi.svg',
            6
        );

        add_action("load-".$this->menu, array($this,"bootstrap_style"));
 
    }

    public function bootstrap_style() {
        
		wp_enqueue_style( $this->plugin_name."_bootstrap", plugin_dir_url( __FILE__ ) . 'css/bootstrap.css', array(), $this->version, 'all' );
		
	}

    function menu_option_page(){
        ?>
        <div class="bootstrap-wrapper">
        <div class="container mt-2">
            <div class="row">
                    <div class="col-12">
                        <div class='bg-dark'>
                        <div class="row">
                            <div class="col-12 col-sm-2 py-2">
                                    <a href="https://www.piwebsolution.com/" target="_blank"><img class="img-fluid ml-2" src="<?php echo plugin_dir_url( __FILE__ ); ?>img/pi-web-solution.png"></a>
                            </div>
                            <div class="col-12 col-sm-10 d-flex text-center small">
                                <?php do_action($this->plugin_name.'_tab'); ?>
                                <!--<a class=" px-3 text-light d-flex align-items-center  border-left border-right  bg-info " href="https://www.piwebsolution.com/documentation-for-live-sales-notifications-for-woocommerce-plugin/">
                                    Documentation
                                </a>-->
                            </div>
                            <div class="col-12 d-flex text-center small">
                                <?php do_action($this->plugin_name.'_sub_tab'); ?>
                            </div>
                        </div>
                        </div>
                    </div>
            </div>
            <div class="row">
                <div class="col-12">
                <div class="bg-light border pl-3 pr-3 pb-3 pt-0">
                    <div class="row">
                        <div class="col">
                        <?php do_action($this->plugin_name.'_tab_content'); ?>
                        </div>
                        <?php do_action($this->plugin_name.'_promotion'); ?>
                    </div>
                </div>
                </div>
            </div>
        </div>
        </div>
        <?php
    }

    function promotion(){
        ?>
         <div class="col-12 col-sm-12 col-md-4 pt-3">
                <div class="bg-dark text-light text-center mb-3">
                    <a href="<?php echo PI_MMQ_BUY_URL; ?>" target="_blank">
                       <?php new pisol_promotion('pisol_mmq_installation_date'); ?>
                    </a>
                </div>

                <div class="bg-dark p-3 text-light text-center mb-3">
                <h2 class="text-light font-weight-light "><span>Get Pro for<br><h1 class="h2 font-weight-bold text-light my-1"><?php echo PI_MMQ_PRICE; ?></h1> <strong class="text-primary">LIMITED</strong> PERIOD OFFER<br>  Buy Now !!</span></h2>
                <div class="inside">
                    PRO version offers more features like<br><br>
                    <ul class="text-left">
                        <li class="border-top py-1 font-weight-light h6">Set <strong>minimum order amount</strong> for complete cart</li>
                        <li class="border-top py-1 font-weight-light h6">Place minimum order amount bar using short code <strong>[pisol_mmq_notification]</strong></li>
                        <li class="border-top py-1 font-weight-light h6">Set Minimum/Maximum quantity on <strong>per product basis</strong></li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Disable global Minimum / Maximum Quantity</strong> on particular product</li>
                        <li class="border-top py-1 font-weight-light h6">Custom messages using <strong>short codes</strong> as per minimum quantity progress</li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Linear progress bar</strong> showing the progress of minimum quantity for each product</li>
                        <li class="border-top py-1 font-weight-light h6">
                        Control the <strong>background color</strong> of the linear progress bar
                        </li>
                        <li class="border-top py-1 font-weight-light h6">
                        Change the background color of the message as per the quantity added in the cart with respect to minimum quantity restriction of the product
                        </li>
                        <li class="border-top py-1 font-weight-light h6">Control minimum message <strong>notification bar position, timing</strong></li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Change the image</strong> shown in the circular progress of minimum order amount</li>
                        <li class="border-top py-1 font-weight-light h6">Show minimum <strong>quantity progress</strong> for each product as linear</li>
                        <li class="border-top py-1 font-weight-light h6">Message is updated using ajax on the Archive pages</li>
                        <li class="border-top py-1 font-weight-light h6">Set <strong>different messages</strong> as per the amount added in the cart with relation to minimum order amount</li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Hide minimum amount progress</strong> after some time interval</li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Change the icon</strong> shown inside the circular progress bar showing the progress of minimum cart amount</li>
                        <li class="border-top py-1 font-weight-light h6">Control the pages <strong>where to show the Minimum amount restriction</strong> notification bar</li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Show/Hide Min Max quantity message</strong> on product archive page, product page, cart page or checkout page</li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Set different position for Min Max quantity message</strong> on product archie page and single product page</li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Don't go inside each product to set Min/Max quantity</strong> set it from the category, so all product will inherit this min/max quantity limit</li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Set minimum quantity</strong> restriction on the category, so user has to buy that many unit from that category</li>
                        <li class="border-top py-1 font-weight-light h6">Checkout page will redirect to cart page when the Minimum quantity/Min Amount restriction is not fulfilled </li>
                        <li class="border-top py-1 font-weight-light h6">Put Minimum amount restriction on the <strong>Category level</strong></li>
                        <li class="border-top py-1 font-weight-light h6"><strong>Exclude product</strong> from Minimum amount restriction set on the Category level</li>
                    </ul>
                    <a class="btn btn-light" href="<?php echo PI_MMQ_BUY_URL; ?>" target="_blank">Click to Buy Now</a>
                </div>
               </div>

            </div>
        <?php
    }

    function isWeekend() {
        return (date('N', strtotime(date('Y/m/d'))) >= 6);
    }

}